<?php
/**
 * Created by PhpStorm.
 * User: costa
 * Date: 25.06.14
 * Time: 15:35
 */

namespace wbp\file\controllers;

use wbp\file\models\File;
use wbp\file\ModuleTrait;
use yii\web\Controller;
use yii;

class GetController extends Controller
{
    use ModuleTrait;
    public function actionIndex()
    {
        echo "Hello, man. It's ok, dont worry.";
    }

    /**
     *
     * All we need is love. No.
     * We need item (by id or another property) and alias (or images number)
     * @param $item
     * @param $size
     *
     */
    public function actionFileByItem($item='',$name='')
    {
        $file= $this->getModule()->getFile($item);
        
        if(!$file || $file->name!=$name){
            throw new \yii\web\HttpException(404, 'There is no file');
        }else{
            $quoted = sprintf('"%s"', addcslashes(basename($file->name), '"\\'));
            $size   = filesize($file->getPathToOrigin());

            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename=' . $quoted);
            header('Content-Transfer-Encoding: binary');
            header('Connection: Keep-Alive');
            header('Expires: 0');
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Pragma: public');
            header('Content-Length: ' . $size);
            readfile($file->getPathToOrigin());
//            header('Content-Type: image/jpg');
//            echo $file->getContent();
        }

    }
}